﻿var surveyCustomProperties = {
    context: $("#surveyCustomProperties"),
    datatable: null,
    bindEvents: function () {
        $(".h-addCustomProperty", surveyCustomProperties.context).on("click", function () {
            modalDialog.showWindow(a4.getAction("EditSurveyCustomPropertyDefinition", "Surveys", "Settings"), 250, 600, { afterClose: function () { surveyCustomProperties.refreshDataTable(); } });
        });
    },
    refreshDataTable: function () {
        surveyCustomProperties.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        surveyCustomProperties.datatable = $(".v-customProprertiesTable", surveyCustomProperties.context).a4datatable({
            height: "full",
            stateKey: "SurveysCustomProperties",
            ajaxAction: a4.getAction("GetCustomPropertyDefinitions", "Surveys", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": true, "Class": "id", "Key": true},
                { "Name": "Name", "Title": resources.CustomPropertyName, "Data": "Name", "Class": "v-name" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Data": "CreatedOn" },
                { "Name": "CreatedBy", "Title": resources.CreatedBy, "Data": "CreatedBy" },
                { "Name": "ModifiedOn", "Title": resources.ModifiedOn, "Data": "ModifiedOn" },
                { "Name": "ModifiedBy", "Title": resources.ModifiedBy, "Data": "ModifiedBy" }
            ],
            localizableTexts: { "Search": resources.SearchCustomProperties },
            defaultSorting: "Name",
            toolBarItems: surveyCustomProperties.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    surveyCustomProperties.deleteItems(ids);
                }
            },
            contextMenuItems: surveyCustomProperties.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "properties": surveyCustomProperties.showEditDialog(row.Id); break;
                    case "delete": surveyCustomProperties.deleteItems(row.Id); break;
                }
            }
        });
    },
    getContextMenuItems: function () {
        var items = [];
        if (canModifySettings) {
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "properties", "Label": resources.Properties });
        }
        return items;
    },
    getToolBarItems: function () {
        var items = [];
        if (canModifySettings) {
            items.push({ "Action": "delete", "Label": resources.Delete });
        }
        return items;
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteCustomPropertyDefinitionResources, function () {
            a4.callServerMethod(a4.getAction("DeleteSurveyCustomPropertyDefinitions", "Surveys", "Settings"), { itemIds: items },
                function (result) {
                    surveyCustomProperties.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    showEditDialog: function (id) {
        modalDialog.showWindow(a4.getAction("EditSurveyCustomPropertyDefinition", "Surveys", "Settings", { id: id }), 350, 650, { afterClose: function () { surveyCustomProperties.refreshDataTable(); } });
    }
}

$(document).ready(function () {
    if (surveyCustomProperties.context.length > 0) {
        surveyCustomProperties.bindEvents();
        surveyCustomProperties.initializeDataTable();
    }
});